using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;

namespace CSharpDemo
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class FormMain : System.Windows.Forms.Form
	{
		private System.Windows.Forms.OpenFileDialog openFileDialog;
		private System.Windows.Forms.FolderBrowserDialog folderBrowserDialog;
		private System.Windows.Forms.ListBox listBox;
		private System.Windows.Forms.Button btnAddFolder;
		private System.Windows.Forms.Button btnAddFile;
		private System.Windows.Forms.Button btnRemove;
		private System.Windows.Forms.Button btnBurn;
		private System.Windows.Forms.Button btnErase;
		private System.Windows.Forms.Button btnEject;
		private System.Windows.Forms.TextBox txtDrive;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.CheckBox cbDVD;
		private System.Windows.Forms.CheckBox cbFull;
		private System.Windows.Forms.RadioButton rbSuperVideo;
		private System.Windows.Forms.RadioButton rbVideo;
		private System.Windows.Forms.RadioButton rbAudio;
		private ZylBurner.Burner burner;
		private System.Windows.Forms.RadioButton rbData;
		private System.Windows.Forms.GroupBox gbType;
        internal Button btnBrowse;
        internal Label Label2;
        internal TextBox txtNeroPath;
		private System.ComponentModel.IContainer components;

		public FormMain()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(FormMain));
            this.openFileDialog = new System.Windows.Forms.OpenFileDialog();
            this.folderBrowserDialog = new System.Windows.Forms.FolderBrowserDialog();
            this.listBox = new System.Windows.Forms.ListBox();
            this.btnAddFolder = new System.Windows.Forms.Button();
            this.btnAddFile = new System.Windows.Forms.Button();
            this.btnRemove = new System.Windows.Forms.Button();
            this.btnBurn = new System.Windows.Forms.Button();
            this.btnErase = new System.Windows.Forms.Button();
            this.btnEject = new System.Windows.Forms.Button();
            this.txtDrive = new System.Windows.Forms.TextBox();
            this.label1 = new System.Windows.Forms.Label();
            this.cbDVD = new System.Windows.Forms.CheckBox();
            this.gbType = new System.Windows.Forms.GroupBox();
            this.rbData = new System.Windows.Forms.RadioButton();
            this.rbSuperVideo = new System.Windows.Forms.RadioButton();
            this.rbAudio = new System.Windows.Forms.RadioButton();
            this.rbVideo = new System.Windows.Forms.RadioButton();
            this.cbFull = new System.Windows.Forms.CheckBox();
            this.burner = new ZylBurner.Burner(this.components);
            this.btnBrowse = new System.Windows.Forms.Button();
            this.Label2 = new System.Windows.Forms.Label();
            this.txtNeroPath = new System.Windows.Forms.TextBox();
            this.gbType.SuspendLayout();
            this.SuspendLayout();
            // 
            // openFileDialog
            // 
            this.openFileDialog.Multiselect = true;
            // 
            // listBox
            // 
            this.listBox.Location = new System.Drawing.Point(104, 8);
            this.listBox.Name = "listBox";
            this.listBox.Size = new System.Drawing.Size(320, 316);
            this.listBox.TabIndex = 0;
            // 
            // btnAddFolder
            // 
            this.btnAddFolder.Location = new System.Drawing.Point(16, 48);
            this.btnAddFolder.Name = "btnAddFolder";
            this.btnAddFolder.Size = new System.Drawing.Size(75, 23);
            this.btnAddFolder.TabIndex = 2;
            this.btnAddFolder.Text = "Add Folder";
            this.btnAddFolder.Click += new System.EventHandler(this.btnAddFolder_Click);
            // 
            // btnAddFile
            // 
            this.btnAddFile.Location = new System.Drawing.Point(16, 16);
            this.btnAddFile.Name = "btnAddFile";
            this.btnAddFile.Size = new System.Drawing.Size(75, 23);
            this.btnAddFile.TabIndex = 3;
            this.btnAddFile.Text = "Add File";
            this.btnAddFile.Click += new System.EventHandler(this.btnAddFile_Click);
            // 
            // btnRemove
            // 
            this.btnRemove.Location = new System.Drawing.Point(16, 80);
            this.btnRemove.Name = "btnRemove";
            this.btnRemove.Size = new System.Drawing.Size(75, 23);
            this.btnRemove.TabIndex = 4;
            this.btnRemove.Text = "Remove";
            this.btnRemove.Click += new System.EventHandler(this.btnRemove_Click);
            // 
            // btnBurn
            // 
            this.btnBurn.Location = new System.Drawing.Point(440, 24);
            this.btnBurn.Name = "btnBurn";
            this.btnBurn.Size = new System.Drawing.Size(75, 23);
            this.btnBurn.TabIndex = 5;
            this.btnBurn.Text = "Burn";
            this.btnBurn.Click += new System.EventHandler(this.btnBurn_Click);
            // 
            // btnErase
            // 
            this.btnErase.Location = new System.Drawing.Point(440, 56);
            this.btnErase.Name = "btnErase";
            this.btnErase.Size = new System.Drawing.Size(75, 23);
            this.btnErase.TabIndex = 6;
            this.btnErase.Text = "Erase";
            this.btnErase.Click += new System.EventHandler(this.btnErase_Click);
            // 
            // btnEject
            // 
            this.btnEject.Location = new System.Drawing.Point(440, 88);
            this.btnEject.Name = "btnEject";
            this.btnEject.Size = new System.Drawing.Size(75, 23);
            this.btnEject.TabIndex = 7;
            this.btnEject.Text = "Eject";
            this.btnEject.Click += new System.EventHandler(this.btnEject_Click);
            // 
            // txtDrive
            // 
            this.txtDrive.Location = new System.Drawing.Point(432, 305);
            this.txtDrive.MaxLength = 1;
            this.txtDrive.Name = "txtDrive";
            this.txtDrive.Size = new System.Drawing.Size(100, 20);
            this.txtDrive.TabIndex = 8;
            // 
            // label1
            // 
            this.label1.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.label1.Location = new System.Drawing.Point(432, 287);
            this.label1.Name = "label1";
            this.label1.Size = new System.Drawing.Size(100, 16);
            this.label1.TabIndex = 9;
            this.label1.Text = "Drive:";
            // 
            // cbDVD
            // 
            this.cbDVD.Location = new System.Drawing.Point(440, 125);
            this.cbDVD.Name = "cbDVD";
            this.cbDVD.Size = new System.Drawing.Size(104, 24);
            this.cbDVD.TabIndex = 10;
            this.cbDVD.Text = "DVD";
            // 
            // gbType
            // 
            this.gbType.Controls.Add(this.rbData);
            this.gbType.Controls.Add(this.rbSuperVideo);
            this.gbType.Controls.Add(this.rbAudio);
            this.gbType.Controls.Add(this.rbVideo);
            this.gbType.Location = new System.Drawing.Point(432, 157);
            this.gbType.Name = "gbType";
            this.gbType.Size = new System.Drawing.Size(137, 120);
            this.gbType.TabIndex = 11;
            this.gbType.TabStop = false;
            this.gbType.Text = "Media Type";
            // 
            // rbData
            // 
            this.rbData.Checked = true;
            this.rbData.Location = new System.Drawing.Point(16, 16);
            this.rbData.Name = "rbData";
            this.rbData.Size = new System.Drawing.Size(104, 24);
            this.rbData.TabIndex = 4;
            this.rbData.TabStop = true;
            this.rbData.Text = "Data";
            // 
            // rbSuperVideo
            // 
            this.rbSuperVideo.Location = new System.Drawing.Point(16, 94);
            this.rbSuperVideo.Name = "rbSuperVideo";
            this.rbSuperVideo.Size = new System.Drawing.Size(104, 16);
            this.rbSuperVideo.TabIndex = 3;
            this.rbSuperVideo.Text = "SuperVideo";
            // 
            // rbAudio
            // 
            this.rbAudio.Location = new System.Drawing.Point(16, 42);
            this.rbAudio.Name = "rbAudio";
            this.rbAudio.Size = new System.Drawing.Size(104, 16);
            this.rbAudio.TabIndex = 1;
            this.rbAudio.Text = "Audio";
            // 
            // rbVideo
            // 
            this.rbVideo.Location = new System.Drawing.Point(16, 69);
            this.rbVideo.Name = "rbVideo";
            this.rbVideo.Size = new System.Drawing.Size(104, 16);
            this.rbVideo.TabIndex = 2;
            this.rbVideo.Text = "Video";
            // 
            // cbFull
            // 
            this.cbFull.Location = new System.Drawing.Point(535, 72);
            this.cbFull.Name = "cbFull";
            this.cbFull.Size = new System.Drawing.Size(48, 24);
            this.cbFull.TabIndex = 12;
            this.cbFull.Text = "Full";
            // 
            // burner
            // 
            this.burner.Artist = "";
            this.burner.CloseSession = false;
            this.burner.ContinueSession = -1;
            this.burner.DisableEject = false;
            this.burner.DiskType = ZylBurner.Burner.DiskTypes.dtData;
            this.burner.DVD = false;
            this.burner.Files = ((System.Collections.ArrayList)(resources.GetObject("burner.Files")));            
            this.burner.HideNeroCmd = false;
            this.burner.ShowMessages = true;
            this.burner.Speed = ((short)(4));
            this.burner.SpeedTest = false;
            this.burner.Synchronous = true;
            this.burner.Tao = false;
            this.burner.Title = "";
            this.burner.UnderrunProtection = false;
            this.burner.Verify = false;
            this.burner.VolumeLabel = "NEW";
            // 
            // btnBrowse
            // 
            this.btnBrowse.Location = new System.Drawing.Point(430, 354);
            this.btnBrowse.Name = "btnBrowse";
            this.btnBrowse.Size = new System.Drawing.Size(75, 23);
            this.btnBrowse.TabIndex = 31;
            this.btnBrowse.Text = "Browse";
            this.btnBrowse.UseVisualStyleBackColor = true;
            this.btnBrowse.Click += new System.EventHandler(this.btnBrowse_Click);
            // 
            // Label2
            // 
            this.Label2.AutoSize = true;
            this.Label2.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.Label2.Location = new System.Drawing.Point(101, 338);
            this.Label2.Name = "Label2";
            this.Label2.Size = new System.Drawing.Size(127, 13);
            this.Label2.TabIndex = 30;
            this.Label2.Text = "Path to NeroCmd.exe";
            // 
            // txtNeroPath
            // 
            this.txtNeroPath.Location = new System.Drawing.Point(104, 354);
            this.txtNeroPath.Name = "txtNeroPath";
            this.txtNeroPath.Size = new System.Drawing.Size(320, 20);
            this.txtNeroPath.TabIndex = 29;
            // 
            // FormMain
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(592, 385);
            this.Controls.Add(this.btnBrowse);
            this.Controls.Add(this.Label2);
            this.Controls.Add(this.txtNeroPath);
            this.Controls.Add(this.cbFull);
            this.Controls.Add(this.gbType);
            this.Controls.Add(this.label1);
            this.Controls.Add(this.txtDrive);
            this.Controls.Add(this.btnEject);
            this.Controls.Add(this.btnErase);
            this.Controls.Add(this.btnBurn);
            this.Controls.Add(this.btnRemove);
            this.Controls.Add(this.btnAddFile);
            this.Controls.Add(this.btnAddFolder);
            this.Controls.Add(this.listBox);
            this.Controls.Add(this.cbDVD);
            this.Name = "FormMain";
            this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
            this.Text = "ZylBurner.NET Demo";
            this.Load += new System.EventHandler(this.FormMain_Load);
            this.gbType.ResumeLayout(false);
            this.ResumeLayout(false);
            this.PerformLayout();

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new FormMain());
		}

		private void btnAddFile_Click(object sender, System.EventArgs e)
		{
			if (openFileDialog.ShowDialog() == DialogResult.OK)
			{
				for(int i = 0; i < openFileDialog.FileNames.Length; i++)
				{
					listBox.Items.Add(openFileDialog.FileNames[i]);
				}
			}
		}

		private void btnAddFolder_Click(object sender, System.EventArgs e)
		{
			if (folderBrowserDialog.ShowDialog() == DialogResult.OK)
			{
				listBox.Items.Add(folderBrowserDialog.SelectedPath);
			}
		}

		private void btnRemove_Click(object sender, System.EventArgs e)
		{
			if (listBox.SelectedIndex >= 0)
			{
				listBox.Items.RemoveAt(listBox.SelectedIndex);
			}
		}

		private void btnBurn_Click(object sender, System.EventArgs e)
		{
            burner.SetNeroCmdLocation(txtNeroPath.Text.Trim());
			if (txtDrive.Text.Trim() != string.Empty && listBox.Items.Count > 0)
			{
				for(int i = 0; i < listBox.Items.Count; i++)
				{
					burner.Files.Add(listBox.Items[i].ToString());
				}		
				burner.DVD = cbDVD.Checked;
				if (rbData.Checked)
					burner.BurnData(txtDrive.Text[0]);
				else if (rbAudio.Checked)
					burner.BurnAudio(txtDrive.Text[0]);
				else if (rbVideo.Checked)
					burner.BurnVideo(txtDrive.Text[0]);
				else if (rbSuperVideo.Checked)
					burner.BurnSuperVideo(txtDrive.Text[0]);
			}
		}

		private void btnErase_Click(object sender, System.EventArgs e)
		{
            burner.SetNeroCmdLocation(txtNeroPath.Text.Trim());
			if (txtDrive.Text.Trim() != string.Empty)
			{
				burner.Erase(txtDrive.Text[0], cbFull.Checked);
			}
		}

		private void btnEject_Click(object sender, System.EventArgs e)
		{
            burner.SetNeroCmdLocation(txtNeroPath.Text.Trim());
			if (txtDrive.Text.Trim() != string.Empty)
			{
				burner.Eject(txtDrive.Text[0]);
			}
		}

		private void burner_Error(object sender, ZylBurner.ErrorEventArgs e)
		{
			MessageBox.Show("Error.");
		}

		private void burner_Success(object sender, System.EventArgs e)
		{
			MessageBox.Show("Success.");
		}

        private void btnBrowse_Click(object sender, EventArgs e)
        {
            if (openFileDialog.ShowDialog() == DialogResult.OK)
                txtNeroPath.Text = openFileDialog.FileName;
        }

        private void FormMain_Load(object sender, EventArgs e)
        {
            txtNeroPath.Text = burner.GetNeroCmdLocation();
        }
	}
}
